<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Add Flyout Button
 * Displays a file download button with optional informational flyouts.
 */
 

 if ( !class_exists( 'avia_sc_dl_button' ) ) 
{
	class avia_sc_dl_button extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Flyout Button', 'avia_framework' );
				$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."dl-btn.png";
				$this->config['order']		= 88;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'av_dl_button';
				$this->config['tooltip'] 	= __('Displays a button with optional informational flyouts.', 'avia_framework' );
				$this->config['tinyMCE']    = array('disable'=>true);
				$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
				$this->config['preview'] 	= true;

			}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}
		
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
					array(
							"name" 	=> "",
							"desc" 	=> __("This is a standard button which has an optional top and bottom flyout. You can use this to link to anyting you want, but it is best suited for file downloads where you would like to display the file name and size.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
								),
					
					array(	"name" 	=> __("Button Label", 'avia_framework' ),
							"desc" 	=> __("This is the text that appears on your button.", 'avia_framework' ),
				            "id" 	=> "label",
				            "type" 	=> "input",
				            "std" => __("DOWNLOAD", 'avia_framework' )),
					
					array(	
							"name" 	=> __("Button Link?", 'avia_framework' ),
							"desc" 	=> __("Where should your button link to?", 'avia_framework' ),
							"id" 	=> "link",
							"type" 	=> "linkpicker",
							"fetchTMPL"	=> true,
							"subtype" => array(	
												__('Set Manually', 'avia_framework' ) =>'manually',
												__('Single Entry', 'avia_framework' ) =>'single',
												__('Taxonomy Overview Page',  'avia_framework' )=>'taxonomy',
												),
							"std" 	=> ""),
							
					array(	
							"name" 	=> __("Open Link in new Window?", 'avia_framework' ),
							"desc" 	=> __("Select here if you want to open the linked page in a new window", 'avia_framework' ),
							"id" 	=> "link_target",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => AviaHtmlHelper::linking_options()),
				    
					array(	"name" 	=> __("Top Flyout Label", 'avia_framework' ),
							"desc" 	=> __("This is the text that appears on the top flyout. Leave blank to disable.", 'avia_framework' ),
				            "id" 	=> "tf_label",
				            "type" 	=> "input",
						    "container_class" => 'av_half',
				            "std" => __("yourfile.zip", 'avia_framework' )),
					
					array(	"name" 	=> __("Bottom Flyout Label", 'avia_framework' ),
							"desc" 	=> __("This is the text that appears on the bottom flyout. Leave blank to disable.", 'avia_framework' ),
				            "id" 	=> "bf_label",
				            "type" 	=> "input",
						    "container_class" => 'av_half',
				            "std" => __("25 MB", 'avia_framework' )),
						
					array(	
							"name" 	=> __("Button Width", 'avia_framework' ),
							"desc" 	=> __("By default the button is set to a width of 200px. In order to keep the flyout styling intact, we must keep a fixed width. Set the width in pixels.", 'avia_framework' ),
							"id" 	=> "size",
							"type" 	=> "input",
							"std" 	=> "200",
							),
					
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					array(
							"type" 	=> "tab",
							"name"	=> __("Colors",'avia_framework' ),
							'nodescription' => true
						),
					
					array(	
							"name" 	=> __("Button Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom background color for your icon.", 'avia_framework' ),
							"id" 	=> "btn_color",
							"container_class" => 'av_half',
							"type" 	=> "colorpicker",
							"std" 	=> "#4285f4",
					 		),
						
					array(	
							"name" 	=> __("Button Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Button here", 'avia_framework' ),
							"id" 	=> "custom_font",
							"container_class" => 'av_half',
							"type" 	=> "colorpicker",
							"std" 	=> "#ffffff",
						),	
					
					array(	
							"name" 	=> __("Top Flyout Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom background color for your icon.", 'avia_framework' ),
							"id" 	=> "tflyout_color",
							"container_class" => 'av_half',
							"type" 	=> "colorpicker",
							"std" 	=> "#252525",
					 		),
						
					array(	
							"name" 	=> __("Top Flyout Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Button here", 'avia_framework' ),
							"id" 	=> "tflyout_font",
							"container_class" => 'av_half',
							"type" 	=> "colorpicker",
							"std" 	=> "#ffffff",
						),
					
					array(	
							"name" 	=> __("Bottom Flyout Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom background color for your icon.", 'avia_framework' ),
							"id" 	=> "bflyout_color",
							"container_class" => 'av_half',
							"type" 	=> "colorpicker",
							"std" 	=> "#252525",
					 		),
						
					array(	
							"name" 	=> __("Bottom Flyout Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Button here", 'avia_framework' ),
							"id" 	=> "bflyout_font",
							"container_class" => 'av_half',
							"type" 	=> "colorpicker",
							"std" 	=> "#ffffff",
						),
											
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
						
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
				);

			}
			
			
			
			/**
			 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
			 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
			 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
			 *
			 *
			 * @param array $params this array holds the default values for $content and $args. 
			 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
			 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}
			
			
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
			   $atts =  shortcode_atts(array('label' => '', 
			                                 'link' => '', 
			                                 'link_target' => '',
			                                 'btn_color' => '',
			                                 'custom_bg' => '#444444',
			                                 'custom_font' => '#ffffff',
			                                 'size' => '200',
			                                 'tf_label' => '',
			                                 'bf_label' => '',
											 'tflyout_color' => '',
											 'tflyout_font' => '',
											 'bflyout_color' => '',
											 'bflyout_font' => '',
			                                 ), $atts, $this->config['shortcode']);
											 
				$label  = $atts['label'];	
				$tflabel  = $atts['tf_label'];
				$tfcolor  = $atts['tflyout_color'];
				$tffont  = $atts['tflyout_font'];
				$bflabel  = $atts['bf_label'];
				$bfcolor  = $atts['bflyout_color'];
				$bffont  = $atts['bflyout_font'];
				$size  = $atts['size'];
				
				$btnwidth = "style='width:".$size."px !important;'";
				
				if($tflabel){
				$topflyout = "<p class='top dlbtn' style='background-color:{$tfcolor} !important;color:{$tffont} !important; width:calc(".$size."px - 20px) !important;'>".$tflabel."</p>";
				}
				if($bflabel){
				$btmflyout = "<p class='bottom dlbtn' style='background-color:{$bfcolor} !important;color:{$bffont} !important; width:calc(".$size."px - 20px) !important;'>".$bflabel."</p>";
				}
				
				$style = "";
				$style .= "style='background-color:".$atts['btn_color']."; border-color:".$atts['btn_color']."; color:".$atts['custom_font']."; width:".$size."px !important;'";

				
			    $blank = strpos($atts['link_target'], '_blank') !== false ? ' target="_blank" ' : "";
			    $blank .= strpos($atts['link_target'], 'nofollow') !== false ? ' rel="nofollow" ' : "";

			    $link  = AviaHelper::get_url($atts['link']);
			    $link  = ( ( $link == "http://" ) || ( $link == "manually" ) ) ? "" : $link;
				
				$output = "<div class='dl_button' {$btnwidth}><a href='".$link."' class='{$av_display_classes}' {$blank} {$style}>".$label."</a>".$topflyout.$btmflyout."</div>";
				
				return $output;
			}
				
	}
}
